#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "dd_spi.h"
#include "initial_setting.h"
#include "serial_flash.h"



void sample_callback(unsigned char SPI_TxRx_Index, unsigned char Data)      //function to be called in case of interrupt
{
  return;
}


void main(void) 
{
  unsigned char data_recieved = 0x00;
  unsigned char data_sent = 0xa0;
  

  EnableInterrupts; /* enable interrupts */
  /* include your code here */
  
  InitConfig();  //Initializes the clock settings and the bus clock is configured to 20Mhz
  
  /*Test code includes the interaction between two SPI's SPI2 is configured as master and SPI1 as slave*/
  
  /*test code starts*/
    
  /*Initilaizes the SPI2 in master mode with slave select pin used as slave select pin and the clock polarity and phase as 0*/
  SPI_Init(SPI_Index2,SPI_MASTER_MODE,
           SPI_SS_PIN_SS_OUTPUT,SPI_CLOCK_POL_0,
           SPI_CLOCK_PHASE_0,0);
 
  /*Initilaizes the SPI1 in master mode with slave select pin used as slave select pin and the clock polarity and phase as 0*/
  SPI_Init(SPI_Index1,SPI_SLAVE_MODE,
           SPI_SS_PIN_SS_OUTPUT,SPI_CLOCK_POL_0,
           SPI_CLOCK_PHASE_0,0);
           
  /*Sends a byte (0xaa) from master spi(SPI2) to slave spi(SPI1) with interrupt disabled*/         
  SPI_Write_Char(SPI_Index2,data_sent,SPI_INTERRUPT_DISABLE);
  
  /*Reads the byte recieved at slave spi(SPI1) */ 
  data_recieved = SPI_Read_Char(SPI_Index1,SPI_INTERRUPT_DISABLE);
  
  if(data_recieved == data_sent) 
  {
    while(1); //success
  } 
  else 
  {
    while(1);//fail
  }
  
  /*test code ends*/
  
  for(;;) {
    __RESET_WATCHDOG(); /* feeds the dog */
  } /* loop forever */
  /* please make sure that you never leave main */
}
